/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.platform;

import com.google.auto.service.AutoService;
import com.tristankechlo.livingthings.entity.SeahorseEntity;
import com.tristankechlo.livingthings.init.ModItems;
import com.tristankechlo.livingthings.platform.IPlatformHelper;
import com.tristankechlo.livingthings.platform.RegistryObject;
import java.nio.file.Path;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import vazkii.patchouli.api.PatchouliAPI;

@AutoService(value={IPlatformHelper.class})
public final class ForgePlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "Forge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public Path getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public Component getPatchouliSubtitle(ResourceLocation bookId) {
        return PatchouliAPI.get().getSubtitle(bookId);
    }

    @Override
    public void openBookEntry(ResourceLocation bookId, ResourceLocation entryId, int page) {
        PatchouliAPI.get().openBookEntry(bookId, entryId, page);
    }

    @Override
    public void openBookGui(ServerPlayer player, ResourceLocation bookId) {
        PatchouliAPI.get().openBookGUI(player, bookId);
    }

    @Override
    public MobBucketItem createMobBucketItem(RegistryObject<EntityType<SeahorseEntity>> type, Fluid fluid, SoundEvent sound, Item.Properties props) {
        return new MobBucketItem(type, () -> fluid, () -> sound, props);
    }

    @Override
    public SpawnEggItem createSpawnEgg(Supplier<EntityType<?>> type, int primaryColor, int secondaryColor, Item.Properties props) {
        return new ForgeSpawnEggItem(() -> (EntityType)type.get(), primaryColor, secondaryColor, props);
    }

    @Override
    public CreativeModeTab.Builder getCreativeModeTab() {
        return CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.livingthings.general")).m_257737_(() -> ModItems.SHARK_TOOTH.get().m_7968_()).m_257501_((parameters, output) -> {
            ModItems.ALL_ITEMS.forEach(item -> output.m_246342_(((Item)item.get()).m_7968_()));
            ModItems.SPAWN_EGGS.forEach(spawnEgg -> output.m_246342_(((Item)spawnEgg.get()).m_7968_()));
        });
    }
}

